#!/bin/sh
DN=`ldapsearch -D "cn=admin,dc=direct,dc=va,dc=gov" -b "ou=accounts,dc=direct,dc=va,dc=gov" -w "{LDAP_ADMIN_PASSWORD}" "(|(uid=$USER)(mail=$USER))" dn | grep 'dn: ' | cut -c 5-999999`
ACL_GROUPS=`ldapsearch -D "cn=admin,dc=direct,dc=va,dc=gov" -b "ou=groups,dc=direct,dc=va,dc=gov" -w "{LDAP_ADMIN_PASSWORD}" "(&(member=$DN))" ou | grep ou: | cut -c5-999999 | tr '\n' ','`
arr=$(echo $ACL_GROUPS | tr ',' '\n')
for x in $arr
do
    if [ ! -d '/var/mailboxes/public/.'$x'.INBOX/' ]; then
        doveadm mailbox create -u vmail 'Public.'$x'.INBOX'
        echo -e 'group='$x 'lwrtsie\nuser=vmail lwrtsipekxa\nanyone' &> '/var/mailboxes/public/.'$x'.INBOX/dovecot-acl'
    fi
    if [ ! -d '/var/mailboxes/public/.'$x'.Sent Messages/' ]; then
        doveadm mailbox create -u vmail 'Public.'$x'.Sent Messages'
        echo -e 'group='$x 'lwrtsie\nuser=vmail lwrtsipekxa\nanyone' &> '/var/mailboxes/public/.'$x'.Sent Messages/dovecot-acl'
    fi
    if [ ! -d '/var/mailboxes/public/.'$x'.Archive/' ]; then
        doveadm mailbox create -u vmail 'Public.'$x'.Archive'
        echo -e 'group='$x 'lwrtsie\nuser=vmail lwrtsipekxa\nanyone' &> '/var/mailboxes/public/.'$x'.Archive/dovecot-acl'
    fi
   if [ ! -d '/var/mailboxes/public/.'$x'.Drafts/' ]; then
        doveadm mailbox create -u vmail 'Public.'$x'.Drafts'
        echo -e 'group='$x 'lwrtsie\nuser=vmail lwrtsipekxa\nanyone' &> '/var/mailboxes/public/.'$x'.Drafts/dovecot-acl'
    fi
    chown -R vmail:vmail /var/mailboxes/public/
    if [ ! -f /var/mailboxes/$(echo $x | tr '[A-Z]' '[a-z]')/.dovecot.sieve ]; then
       echo -e 'require ["fileinto"];\n' >> /var/mailboxes/$(echo $x | tr '[A-Z]' '[a-z]')/.dovecot.sieve
       chown 5000:5000 /var/mailboxes/$(echo $x | tr '[A-Z]' '[a-z]')/.dovecot.sieve
    fi
    if [ -z $(cat /var/mailboxes/$(echo $x | tr '[A-Z]' '[a-z]')/.dovecot.sieve | grep -o -m 1  $x) ]; then
        echo -e 'if address :is ["To","Cc","Bcc"] "'$x'@direct.domain" {\n    fileinto "Public.'$x'.INBOX";\n }' >> /var/mailboxes/$(echo $x | tr '[A-Z]' '[a-z]')/.dovecot.sieve
    fi
done
export ACL_GROUPS
export USERDB_KEYS="$USERDB_KEYS acl_groups"
exec "$@"